function [x,data,k] = Newton_unconstr(objfun,Q,h,x0,alpha_start,beta)

% Parameters
MAXITER = 5; %maximum number of iterations
alpha_tol = 1e-3;
gamma = 0.5;

xk = x0;

% save iterate information
data    = [];
data.x0 = x0;
data.x  = []; % iterates
data.d  = []; % search directions

% print the header
printIter();

tic
for k = 1:MAXITER
    
    % compute function and gradient
    [f_k,g_k,H_k] = objfun(xk);

    
    % compute search direction (just opposite of the gradient)
    d_k = linsolve(H_k,-g_k);
    
    % initial step size
    alpha_k = alpha_start;

    %linesearch by armijo backtracking

    xk1 = xk + alpha_k*d_k;

    f_k1 = objfun(xk1);
    
    while f_k1 > f_k + gamma*alpha_k*g_k'*(d_k) && alpha_k > alpha_tol
        
%         disp('backtracked')
        % backstep alpha_k
        alpha_k = beta * alpha_k;

        % evaluate function at new iterate
        xk1 = xk + alpha_k*d_k;
        f_k1 = objfun(xk1);
        d_k = xk1 - xk;               
    end
    

    % record the iterates
    if nargout >= 2
        data.x = [data.x,xk];
        data.d = [data.d,d_k];
    end
    
    % update iterate for next iteration
    xk = xk1;
    
    % print progress
    printIter(k, f_k, norm(d_k), alpha_k, toc);
    
end

%final point 
x = xk;
data.x = [data.x,xk];
data.d = [data.d,d_k];
end


function printIter(iter, f_k, d_k_norm, alpha_k, CPUtime)
% print the iteration progress

if nargin==0
% Store output header and footer strings as persistent variables
out_line = '================================================================================';
out_data = '  k        f        ||d||        alpha       CPU (s)';

% print algorithm output header
fprintf('\nBeginning gradient descent ...\n')
fprintf('%s\n%s\n%s\n', out_line, out_data, out_line)
return;
end

% Print iterate information
fprintf('% 4d  % .4e  % .4e  % .4e   % .5f\n',iter, f_k, d_k_norm, alpha_k, CPUtime);



end
